// ****************************************************************************
// 
// AVSAmp
// Copyright (C) 2005  Moitah (moitah@yahoo.com)
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
// 
// ****************************************************************************

#include <iostream>
#include <iomanip>
#include <windows.h>
#include <vfw.h>

using namespace std;

typedef signed short sint16;

const int NUM_SAMPS = 48000 * 2;

#define ERR(x) err = true; cout << "\r" << x << "\n"; goto ErrHand

int main(int argc, char* argv[]) {
	bool err = false;
	char *pathSrc;
	PAVIFILE pAviFile = NULL;
	PAVISTREAM pAudioStream = NULL;
	AVISTREAMINFO audioStreamInfo;
	WAVEFORMATEX audioFormat;
	LONG asiLen, afLen;
	sint16 *audioBuff = new sint16[NUM_SAMPS];
	LONG sampOffset, sampTotal, sampRead;
	sint16 maxSamp = 0;
	DWORD tickCount, lastProg = 0;

	if (argc < 2) {
		cout << "AVSAmp v1.0.0 by Moitah\n\n"
			 << "Usage: \n"
			 << "avsamp source_path\n";

		return 0;
	}
	pathSrc = argv[1];
	cout << fixed << showpoint;

	AVIFileInit();

	// Open AVI
	if (AVIFileOpen(&pAviFile, pathSrc, OF_SHARE_DENY_WRITE, 0) != AVIERR_OK) {
		pAviFile = NULL;
		ERR("AVIFileOpen failed!");
	}

	// Get the handle for the audio stream
	if (AVIFileGetStream(pAviFile, &pAudioStream, streamtypeAUDIO, 0) != AVIERR_OK) {
		pAudioStream = NULL;
		ERR("AVIFileGetStream failed!");
	}

	// Read AVISTREAMINFO header
	asiLen = sizeof(AVISTREAMINFO);
	ZeroMemory(&audioStreamInfo, asiLen);
	if (AVIStreamInfo(pAudioStream, &audioStreamInfo, asiLen) != AVIERR_OK) {
		ERR("AVIStreamInfo failed!");
	}

	// Read WAVEFORMATEX header
	afLen = sizeof(WAVEFORMATEX);
	ZeroMemory(&audioFormat, afLen);
	if (AVIStreamReadFormat(pAudioStream, 0, &audioFormat, &afLen) != AVIERR_OK) {
		ERR("AVIStreamReadFormat failed!");
	}

	if (audioFormat.wFormatTag != 0x0001) {
		ERR("Audio must be in PCM format!");
	}
	if (audioFormat.wBitsPerSample != 16) {
		ERR("Audio must be 16 bits per sample!");
	}

	sampOffset = 0;
	sampTotal = audioStreamInfo.dwLength;

	while (sampOffset < sampTotal) {
		// Read some audio samples
		if (AVIStreamRead(pAudioStream, sampOffset, AVISTREAMREAD_CONVENIENT,
			audioBuff, NUM_SAMPS, NULL, &sampRead) != AVIERR_OK)
		{
			ERR("AVIStreamRead failed!");
		}

		// Update max sample value
		for (int i = 0; i < sampRead * audioFormat.nChannels; i++) {
			short x = abs( *(audioBuff + i) );
			if (x > maxSamp) {
				maxSamp = x;
			}
		}

		// Update progress
		tickCount = GetTickCount();
		if ((tickCount - lastProg) >= 200) {
			cout << "\r" << setprecision(2) <<
				(((double)sampOffset / (double)sampTotal) * 100.0) << "%     ";
			lastProg = tickCount;
		}

		sampOffset += sampRead;
	}
	cout << "\r100%     \n";

ErrHand: // Errors jump here, finish up

	if (pAudioStream) {
		AVIStreamRelease(pAudioStream);
		pAudioStream = NULL;
	}
	if (pAviFile) {
		AVIFileClose(pAviFile);
		pAviFile = NULL;
	}
	AVIFileExit();

	delete[] audioBuff;

	if (!err) {
		cout << "Amplify by " << setprecision(6) << (32768.0 / (double)maxSamp) <<
			" for full-scale.\n";
	}

	return 0;
}
